
CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1                  
				FROM 
					information_schema.columns     
                WHERE 
					table_name ilike ('pdv_campanha_adicionais')
					and column_name ilike ('flag_tp_desconto_propz')
	) THEN
         RAISE NOTICE 'Coluna  FLAG_ENVIO_PROPZ  na tabela  pdv_campanha_adicionais  ja existe!' ;
    ELSE
		ALTER TABLE pdv_campanha_adicionais ADD flag_tp_desconto_propz INT NOT NULL DEFAULT 0;
        RAISE NOTICE 'Coluna "flag_tp_desconto_propz" criada com sucesso!';
    END IF;     
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();

